(function () {
  function buildFormData(payload) {
    var form = new FormData();
    if (!payload) return form;
    var entries = Array.isArray(payload) ? payload : Object.entries(payload);
    for (var i = 0; i < entries.length; i++) {
      var pair = entries[i];
      if (!pair || pair.length < 2) continue;
      form.append(pair[0], pair[1]);
    }
    return form;
  }

  function parseResponseHeaders(raw) {
    var result = {};
    try {
      if (!raw) return result;
      var lines = raw.trim().split(/[\r\n]+/);
      for (var i = 0; i < lines.length; i++) {
        var parts = lines[i].split(': ');
        if (parts.length === 2) {
          result[parts[0].trim()] = parts[1].trim();
        }
      }
    } catch (_e) {
      return result;
    }
    return result;
  }

  window.addEventListener('message', function (event) {
    var data = event && event.data;
    if (!data || data.source !== 'prod' || data.type !== 'TKSHOP_XHR_REQUEST') return;

    var url = data.url;
    var method = data.method || 'GET';
    var headers = data.headers || null;
    var body = data.body;
    var requestId = data.requestId;
    var isFormData = Boolean(data.isFormData);

    var xhr = new XMLHttpRequest();
    try {
      if (isFormData) {
        body = buildFormData(body);
      }

      xhr.open(method, url, true);
      xhr.setRequestHeader('Accept', 'application/json');
      if (headers) {
        Object.keys(headers).forEach(function (key) {
          xhr.setRequestHeader(key, headers[key]);
        });
      }
      if (body && method !== 'GET' && !isFormData) {
        xhr.setRequestHeader('Content-Type', 'application/json');
      }

      xhr.onloadend = function () {
        var responseURL = xhr.responseURL;
        var responseHeaders = {};
        try {
          responseHeaders = parseResponseHeaders(xhr.getAllResponseHeaders());
        } catch (_e) {
          responseHeaders = {};
        }

        if (responseURL && responseURL.indexOf('msToken') === -1) {
          window.postMessage({ type: 'TKSHOP_UPDATE_REQUEST_VERSION', source: 'prod' }, '*');
        }

        var response = null;
        try {
          response = xhr.responseText;
        } catch (_e) {
          response = null;
        }

        window.postMessage(
          {
            type: 'TKSHOP_XHR_RESPONSE',
            source: 'prod',
            requestId: requestId,
            url: url,
            status: xhr.status,
            statusText: xhr.statusText || 'statusText为空',
            response: response,
            responseHeaders: responseHeaders,
            responseURL: responseURL,
            readyState: xhr.readyState,
          },
          '*',
        );
      };

      xhr.send(method === 'GET' ? null : body);
    } catch (e) {
      window.postMessage(
        {
          type: 'TKSHOP_XHR_RESPONSE',
          source: 'prod',
          requestId: requestId,
          url: url,
          status: xhr.status,
          statusText: xhr.statusText || 'statusText为空',
          error: 'catch错误：' + (e && e.message ? e.message : String(e)),
        },
        '*',
      );
    }
  });
})();
